/*------------------------------------------------------------------------------*
 * File Name: UsingGetNOptions.c												*
 * Creation: GJL 9/04/2003														*
 * Purpose: Origin C file containing GetNBox example codes.						*
 * Copyright (c) OriginLab Corp.	2003-2007									*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include <GetNBox.h>

void UsingGetNOptions()
{
	// Use GETN_TREE macro to declare a tree for a Tree style GetN dialog
	GETN_TREE(tr)
	GETN_OPTION_GRIDLINE(flexGridRaisedVert) // Option to add vertical divider line

	// Add a string edit box node named WksName having caption "Worksheet Name"
	// initialized to string value "Data1"
	GETN_STR(WksName, "Worksheet Name", "Data1")
	GETN_OPTION_COLOR_LABEL(COLOR_RED) // Option to color node label red

	// Group following nodes in collapseable branch named Fit having caption
	// "Fitting Options"
	GETN_BEGIN_BRANCH(Fit, "Fitting Options")
		GETN_OPTION_COLOR_LABEL(COLOR_NAVY) // Option to color branch label navy blue

		// Option to expand branch when dialog opens and to keep dialog same size when collapsing branch
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN | GETNBRANCH_KEEP_SIZE_ON_COLLAPSE)	

		// Use macro to add a checkbox node named ThroughZero having caption
		// "Force Fit Line Through Zero" initialized to true (checked)
		GETN_CHECK(ThroughZero, "Force Fit Line Through Zero", true)
		GETN_OPTION_COLOR_LABEL(COLOR_NAVY) // Option to color node label navy blue

		// Add a numeric edit box node named YIntercept having caption "Y Intercept"
		// initialized to numeric value 1.5
		GETN_NUM(YIntercept, "Y Intercept", 1.5)
		GETN_OPTION_COLOR_LABEL(COLOR_NAVY) // Option to color node label navy blue

		// Add non-editable drop down list box node named Order having caption
		// "Polynomial Order" initialized to 2 with list values 2,3,4,5,6
		GETN_COMBO(Order, "Polynomial Order", 2, "2|3|4|5|6")
		GETN_OPTION_COLOR_LABEL(COLOR_NAVY) // Option to color node label navy blue

	// End nodes in collapseable branch
	GETN_END_BRANCH(Fit)

	GETN_BUTTON(Path, "File path", "c:\\")
	GETN_OPTION_COLOR_LABEL(COLOR_GREEN) // Option to color node label green
	GETN_OPTION_EVENT(RowBasedOnClickButtonEvent) // Option specifying event handler for browsing

	// Output GetNBox tree before editing input defaults
	out_tree(tr);

	// Open GetNBox dialog and edit input defaults passing GetN tree named tr
	// and having dialog title "Using GetN Macros" and dialog description "This is
	// a GetN dialog with options"
	if( GetNBox(tr, "Using GetN Options", "This is a GetN dialog with options specified", NULL, NULL) )
		out_tree(tr); // If user clicks OK to close dialog Output edited GetNBox tree
}

// This function is executed when the browse button for the Path node is clicked
static bool RowBasedOnClickButtonEvent(TreeNode& tr, int nRow, int nCntrlType, Dialog& getNDlg)
{
	string str = BrowseGetPath(GetAppPath() + "OriginC\\", "Browse");
	if( !str.IsEmpty() )
	{
		tr.Path.strVal = str;
		return true;
	}
	else
		return false;
}